---
name: managing-tasks-document
description: Manage tasks.md documents for Spec-Driven Development (SDD)
allowed-tools: Read, Grep, Glob, Edit, Write
---

# managing sdd tasks markdown

## Prerequisites
This Skill manages `tasks.md` documents for Spec-Driven Development (SDD).  It lists step-by-step tasks to generate codes for user's requirement.

Project directory structure of tasks.md :

```
.codeartsdoer/
└── specs/
    └──{{feature-name}}/
        └── tasks.md
```

**Note**: The `.codeartsdoer/specs/{{feature-name}}/tasks.md` file can be generated only if the`.codeartsdoer/specs/{{feature-name}}/spec.md` and `.codeartsdoer/specs/{{feature-name}}/design.md` files exist.

## The Process

### Step 1: Comprehend feature requirement

- read the `.codeartsdoer/specs/{{feature-name}}/spec.md` to obtaining project background and characteristic list
- read the `.codeartsdoer/specs/{{feature-name}}/design.md` to obtaining the design of code
- understanding the feature requirements in context

### Step 2: Generate implementation tasks

- Use Chinese unless user requests otherwise
- Map all requirements to tasks
- Ensure all design components included
- Verify task progression is logical and incremental

### Step 3: Save tasks
- if `.codeartsdoer/specs/{{feature-name}}/tasks.md` not exist, create it.

- **Save tasks to:** `.codeartsdoer/specs/{{feature-name}}/tasks.md`